#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

#define TRACE(x) cerr << #x << " = " << x << endl
#define FOR(i, a, b) for (int i = (a); i < int(b); i++)
#define REP(i, n) FOR(i, 0, n)
#define all(x) (x).begin(), (x).end()
#define _ << ", " <<

#define brisanja first
#define nacina second

const int NN = 100100;
const int MOD = 1000000007;
int kamo[NN], bio[NN], predstavnik;
bool ciklus[NN];
vector<int> ulazi[NN];
pair<int, int> dp0[NN][3], dp1[NN][3][3];
int memo0[NN][3], memo1[NN][3][3];

pair<int, int> ili(pair<int, int> x, pair<int, int> y) {
    if (x.nacina == 0) return y;
    if (y.nacina == 0) return x;
    if (x.brisanja == y.brisanja)
        return make_pair(x.brisanja, (x.nacina + y.nacina) % MOD);
    if (x.brisanja < y.brisanja)
        return x;
    return y;
}

pair<int, int> presjek(pair<int, int> x, pair<int, int> y) {
    return make_pair(x.brisanja + y.brisanja, 1LL * x.nacina * y.nacina % MOD);
}

pair<int, int> stablo_dp(int trenutni, int boja) {
    pair<int, int> & ret = dp0[trenutni][boja];
    if (ret.brisanja != -1) return ret;
    ret = make_pair(0, 1);
    for (auto x : ulazi[trenutni]) {
        if (ciklus[x]) continue;
        if (boja == 0) {     // 0 -> 0 ili 2 -> 0
            pair<int, int> grana = ili(stablo_dp(x, 0), stablo_dp(x, 2));
            ret = presjek(ret, grana);
        }
        else if (boja == 1)  // 0 -> 1
            ret = presjek(ret, stablo_dp(x, 0));
        else {               // 0 -> 2 ili 1 -> 2
            pair<int, int> grana = ili(stablo_dp(x, 0), stablo_dp(x, 1));
            ret = presjek(ret, grana);
        }
    }
    if (boja == 0)
        ret.brisanja += 1;
    return ret;
}

pair<int, int> ciklus_dp(int trenutni, int boja_prvog, int boja_prethodnog) {
    pair<int, int> & ret = dp1[trenutni][boja_prvog][boja_prethodnog];
    if (ret.brisanja != -1) return ret;
    if (trenutni == predstavnik) {  // natrag na prvom
        ret.brisanja = 0;
        if (boja_prethodnog == 0)       // 0 -> 1,2,3
            ret.nacina = 1;
        else if (boja_prethodnog == 1)  // 1 -> 2
            ret.nacina = (boja_prvog == 2);
        else                            // 2 -> 0
            ret.nacina = (boja_prvog == 0);
    }
    else {
        int sljedeci = kamo[trenutni];
        if (boja_prethodnog == 0) {     // 0 -> 0,1,2
            ret = make_pair(0, 0);
            REP(boja, 3) {
                pair<int, int> mogucnost = presjek(stablo_dp(trenutni, boja),
                        ciklus_dp(sljedeci, boja_prvog, boja));
                ret = ili(ret, mogucnost);
            }
        }
        else if (boja_prethodnog == 1)  // 1 -> 2
            ret = presjek(stablo_dp(trenutni, 2),
                    ciklus_dp(sljedeci, boja_prvog, 2));
        else                           // 2 -> 0
            ret = presjek(stablo_dp(trenutni, 0),
                    ciklus_dp(sljedeci, boja_prvog, 0));
    }
    return ret;
}

int main() {
    ios::sync_with_stdio(false);
    int n; 
    cin >> n;
    REP(i, n) {
        cin >> kamo[i];
        --kamo[i];
        ulazi[kamo[i]].push_back(i);
    }

    pair<int, int> rjesenje = make_pair(0, 1);
    REP (i, n) {
        bio[i] = -1;
        REP (boja, 3) {
            dp0[i][boja].brisanja = -1;
            REP (boja2, 3)
                dp1[i][boja][boja2].brisanja = -1;
        }
    }

    // Detekcija ciklusa
    REP(i, n) {
        predstavnik = -1;
        if (bio[i] != -1) continue;
        bio[i] = i;
        int j = i;
        while (1) {
            j = kamo[j];
            if (bio[j] == -1)
                bio[j] = i;
            else if (bio[j] == i) {
                predstavnik = j;
                break;
            }
            else {
                predstavnik = -1;
                break;
            }
        }
        if (predstavnik != -1) {
            ciklus[predstavnik] = true;
            j = kamo[predstavnik];
            while (j != predstavnik) {
                ciklus[j] = true;
                j = kamo[j];
            }
            pair<int, int> rjesenje_ciklusa = make_pair(0, 0);
            REP(boja, 3) {
                pair<int, int> mogucnost = presjek(stablo_dp(predstavnik, boja),
                        ciklus_dp(kamo[predstavnik], boja, boja));
                rjesenje_ciklusa = ili(rjesenje_ciklusa, mogucnost);
            }
            rjesenje = presjek(rjesenje, rjesenje_ciklusa);
        }
    }
    cout << rjesenje.brisanja << endl << rjesenje.nacina << endl;
    return 0;
}
